/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.metrics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.net.HttpRequestBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.ExceptionHandler;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyScreen;
import com.megacrit.cardcrawl.daily.TimeHelper;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import java.io.File;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Metrics
implements Runnable {
    private static final Logger logger = LogManager.getLogger(Metrics.class.getName());
    private HashMap<Object, Object> params = new HashMap();
    private Gson gson = new Gson();
    private static final String save_path = "runs" + File.separator + "metrics";
    private long lastPlaytimeEnd;
    public boolean death;
    public MonsterGroup monsters = null;
    public MetricRequestType type;

    public void setValues(boolean death, MonsterGroup monsters, MetricRequestType type) {
        this.death = death;
        this.monsters = monsters;
        this.type = type;
    }

    public void sendPost(String fileName) {
        String url = "https://metrics.megacrit.com/input/playthrough";
        this.sendPost(url, fileName);
    }

    public void addData(Object key, Object value) {
        this.params.put(key, value);
    }

    public void sendPost(String url, final String fileToDelete) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(hostname.getBytes());
        }
        catch (UnknownHostException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            ExceptionHandler.handleException(e, logger);
        }
        event.put("event", this.params);
        if (Settings.isBeta) {
            event.put("host", CardCrawlGame.playerName);
        } else {
            event.put("host", CardCrawlGame.alias);
        }
        event.put("time", System.currentTimeMillis() / 1000L);
        String data = this.gson.toJson(event);
        logger.info("UPLOADING METRICS TO: url=" + url + ",data=" + data);
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        Net.HttpRequest httpRequest = requestBuilder.newRequest().method("POST").url(url).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Splunk 1D431505-C592-4C3D-A029-784BFE7A281B").header("User-Agent", "curl/7.43.0").build();
        httpRequest.setContent(data);
        Gdx.net.sendHttpRequest(httpRequest, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                logger.info("Metrics: http request response: " + httpResponse.getResultAsString());
                if (fileToDelete != null) {
                    Gdx.files.local(fileToDelete).delete();
                }
            }

            @Override
            public void failed(Throwable t) {
                logger.info("Metrics: http request failed: " + t.toString());
                if (fileToDelete == null) {
                    Metrics.this.saveMetricData();
                }
            }

            @Override
            public void cancelled() {
                logger.info("Metrics: http request cancelled.");
                if (fileToDelete == null) {
                    Metrics.this.saveMetricData();
                }
            }
        });
    }

    public void saveMetricData() {
        if (Settings.UPLOAD_DATA) {
            String data = this.gson.toJson(this.params);
            FileHandle file = Gdx.files.local(save_path + File.separator + this.lastPlaytimeEnd + ".metrics");
            file.writeString(data, false);
        }
    }

    public void gatherAllData(boolean death, MonsterGroup monsters) {
        this.addData("play_id", UUID.randomUUID().toString());
        this.addData("build_version", CardCrawlGame.TRUE_VERSION_NUM);
        this.addData("seed_played", Settings.seed.toString());
        this.addData("is_daily", Settings.isDailyRun);
        this.addData("is_trial", Settings.isTrial);
        this.addData("is_hardmode", false);
        this.addData("is_prod", Settings.isDemo);
        this.addData("victory", !death);
        this.addData("floor_reached", AbstractDungeon.floorNum);
        this.lastPlaytimeEnd = System.currentTimeMillis() / 1000L;
        this.addData("playtime", this.lastPlaytimeEnd - AbstractDungeon.playtimeStart);
        this.addData("player_experience", Settings.totalPlayTime);
        this.addData("master_deck", AbstractDungeon.player.masterDeck.getCardNames());
        this.addData("relics", AbstractDungeon.player.getRelicNames());
        this.addData("gold", AbstractDungeon.player.gold);
        this.addData("campfire_rested", CardCrawlGame.metricData.campfire_rested);
        this.addData("campfire_upgraded", CardCrawlGame.metricData.campfire_upgraded);
        this.addData("campfire_rituals", CardCrawlGame.metricData.campfire_rituals);
        this.addData("campfire_meditates", CardCrawlGame.metricData.campfire_meditates);
        this.addData("purchased_purges", CardCrawlGame.metricData.purchased_purges);
        this.addData("potions_floor_spawned", CardCrawlGame.metricData.potions_floor_spawned);
        this.addData("potions_floor_usage", CardCrawlGame.metricData.potions_floor_usage);
        this.addData("current_hp_per_floor", CardCrawlGame.metricData.current_hp_per_floor);
        this.addData("max_hp_per_floor", CardCrawlGame.metricData.max_hp_per_floor);
        this.addData("gold_per_floor", CardCrawlGame.metricData.gold_per_floor);
        this.addData("path_per_floor", CardCrawlGame.metricData.path_per_floor);
        this.addData("path_taken", CardCrawlGame.metricData.path_taken);
        this.addData("items_purchased", CardCrawlGame.metricData.items_purchased);
        this.addData("items_purged", CardCrawlGame.metricData.items_purged);
        this.addData("character_chosen", AbstractDungeon.player.chosenClass.name());
        this.addData("card_choices", CardCrawlGame.metricData.card_choices);
        this.addData("event_choices", CardCrawlGame.metricData.event_choices);
        this.addData("boss_relics", CardCrawlGame.metricData.boss_relics);
        this.addData("damage_taken", CardCrawlGame.metricData.damage_taken);
        if (death && monsters != null) {
            this.addData("killed_by", AbstractDungeon.lastCombatMetricKey);
        } else {
            this.addData("killed_by", null);
        }
    }

    public void gatherAllDataAndSend(boolean death, MonsterGroup monsters) {
        this.gatherAllData(death, monsters);
        this.sendPost(null);
    }

    public void gatherAllDataAndSave(boolean death, MonsterGroup monsters) {
        this.gatherAllData(death, monsters);
        String data = this.gson.toJson(this.params);
        FileHandle file = !Settings.isDailyRun ? Gdx.files.local("runs" + File.separator + AbstractDungeon.player.chosenClass.name() + File.separator + this.lastPlaytimeEnd + ".run") : Gdx.files.local(DailyScreen.daily_save_path + File.separator + TimeHelper.daySince1970 + ".run");
        file.writeString(data, false);
    }

    public void sendFailedMetricData(HashMap oldData, String filePath) {
        this.params = oldData;
        if (Settings.UPLOAD_DATA) {
            this.sendPost(filePath);
        }
    }

    public static void uploadAllFailedMetricData() {
        FileHandle[] files;
        for (FileHandle file : files = Gdx.files.local(save_path).list()) {
            logger.info("Failed Metric Data Exists: " + file.path());
            Type type = new TypeToken<HashMap<Object, Object>>(){}.getType();
            HashMap oldMetrics = (HashMap)new Gson().fromJson(file.readString(), type);
            new Metrics().sendFailedMetricData(oldMetrics, file.path());
        }
    }

    @Override
    public void run() {
        switch (this.type) {
            case UPLOAD_CRASH: {
                this.gatherAllDataAndSend(this.death, this.monsters);
                break;
            }
            case UPLOAD_FAILED_METRICS: {
                Metrics.uploadAllFailedMetricData();
                break;
            }
            case UPLOAD_METRICS: {
                this.gatherAllDataAndSend(this.death, this.monsters);
                break;
            }
            default: {
                logger.info("Unspecified MetricRequestType: " + this.type.name() + " in run()");
            }
        }
    }

    public static enum MetricRequestType {
        UPLOAD_METRICS,
        UPLOAD_CRASH,
        UPLOAD_FAILED_METRICS,
        NONE;

    }
}

